package cn.freemud.platform.sdk.hualala;

import cn.freemud.platform.sdk.common.service.CloudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/22 11:15
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class HualalaConfig {
    @Bean("hualalaRestTemplate")
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
    @ConditionalOnMissingBean
    @Bean
    public CloudService cloudService(@Autowired @Qualifier("hualalaRestTemplate") RestTemplate restTemplate) {
        return new CloudService(restTemplate);
    }

    @Bean
    public HualalaSdkService hualalaSdkService(@Autowired CloudService cloudService) {
        return new HualalaSdkService(cloudService);
    }
}
