package cn.freemud.platform.sdk.common.util;

import org.springframework.util.Base64Utils;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/18 22:11
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class AesCBCNoPaddingUtil {

    public static String encrypt(String plaintext, String ivParameterm, String secretKey) {
        byte[] bytOut = null;
        try {
            byte[] plaintextByte = plaintext.getBytes("UTF-8");
            int len = plaintextByte.length;
            while (len % 16 != 0) len++;
            byte[] result = new byte[len];
            for (int i = 0; i < len; ++i) {
                if (i < plaintextByte.length) {
                    result[i] = plaintextByte[i];
                } else {
                    result[i] = ' ';
                }
            }
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), "AES");
            Cipher cipher = null;
            IvParameterSpec iv = new IvParameterSpec(ivParameterm.getBytes());
            cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(Cipher.ENCRYPT_MODE, key, iv);
            bytOut = cipher.doFinal(result);
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return Base64Utils.encodeToString(bytOut);
    }


    public static String decrypt(String ciphertext, String ivParameterm, String secretKey) {
        SecretKeySpec skeySpec = new SecretKeySpec(secretKey.getBytes(), "AES");
        Cipher cipher = null;
        IvParameterSpec iv = new IvParameterSpec(ivParameterm.getBytes());
        byte[] bytOut = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/NOPadding");
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
            bytOut = cipher.doFinal(Base64Utils.decodeFromString(ciphertext));
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return new String(bytOut);
    }


    public static void main(String[] args) {
        String en=encrypt("{'needCardLevelList': 'true', 'transWay': 'true'}", "1234567812345678", "1234567812345678");
        System.out.println(en);
        System.out.println(decrypt(en,"1234567812345678", "1234567812345678"));
    }
}
