package com.freemud.application.sdk.api.ordercenter.service;

import com.freemud.application.sdk.api.ordercenter.adapter.OrderCenterSdkAdapter;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.QueryByCodeResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceV1 {

    @Autowired
    private OrderSdkService orderSdkService;
    @Autowired
    private OrderCenterSdkAdapter orderCenterSdkAdapter;

    /**
     * 根据订单编号查询订单信息
     * 返回 V1版本订单数据结构
     */
    public OrderBeanV1 queryOrderById(String orderClient, String orderCode, String thirdOrderCode, Integer withOperationHistory, String trackingNo){
        QueryByCodeResponse orderInfo = orderSdkService.getOrderInfo(orderClient, orderCode, thirdOrderCode, withOperationHistory, trackingNo);
        if(orderInfo == null || orderInfo.getResult() == null || StringUtils.isEmpty(orderInfo.getResult().getOrderCode())){
            return null;
        }
        return orderCenterSdkAdapter.convent2NEWOrderInfo(orderInfo.getResult());
    }



}
