package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

public enum OrderTypeV1 {

    TAKE_OUT(1, "外卖", "takeOut"),
//    PRE_ORDER(2, "预订单", "preOrder"),
//    MALL(3, "商城", "mall"),
    COLLECT_GOODS(4, "自提", "collectGoods"),
    EAT_IN(5, "堂食", "eatIn");

    private Integer code;
    private String desc;
    /**
     * 对应取餐码key规则
     */
    private String tackDesc;

    OrderTypeV1(Integer code, String desc, String tackDesc) {
        this.code = code;
        this.desc = desc;
        this.tackDesc = tackDesc;
    }

    public static List<Integer> getAllCodes() {
        List<Integer> list = Lists.newArrayList();
        for (OrderTypeV1 orderType : values()) {
            list.add(orderType.getCode());
        }
        return list;
    }


    public static OrderTypeV1 getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OrderTypeV1 orderType : values()) {
            if (orderType.getCode().equals(code)) {
                return orderType;
            }
        }
        return null;
    }

    public static List getByCode(List<Integer> list) {
        List returnList = new ArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return returnList;
        }
        for (OrderTypeV1 orderType : values()) {
            for (Integer code : list) {
                if (orderType.getCode().equals(code)) {
                    returnList.add(code);
                }
            }
        }
        return returnList;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTackDesc() {
        return tackDesc;
    }

    public void setTackDesc(String tackDesc) {
        this.tackDesc = tackDesc;
    }

}
