package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

public enum OrderStatusV1 {

    WAIT_PAY("待支付",2,1,"To be paid"),
    TAKE_ORDER( "下单",1,2,"place an order"),
    RECEIPT("已接单",3,3,"Receiving orders"),
    COMPLETE_MAKE("制作完成(待发货)",31,4,"Production completed"),
    DISTRIBUTION("配送中",4,5,"In delivery"),
    COMPLETE( "已完成",5,6,"Complete"),
    CANCEL( "已关闭",6,7,"Cancel")

    ;

    private String desc;
    private Integer code;
    private Integer v2Code;
    private String descEn;


    /**
     * 获取V1 老订单状态值
     */
    public static Integer getOldCode(Integer v2Code) {
        Integer v1Code = OrderStatusV1.WAIT_PAY.getCode();
        if (v2Code == null ) return v1Code;
        for (OrderStatusV1 value : OrderStatusV1.values()) {
            if (value.getV2Code().equals(v2Code)) {
                v1Code = value.getCode();
                break;
            }
        }
        return v1Code;
    }

    /**
     * 获取V2 新订单状态值
     */
    public static Integer getNewCode(Integer code) {
        Integer v2Code = OrderStatusV1.WAIT_PAY.getV2Code();
        if (code == null ) return v2Code;
        for (OrderStatusV1 value : OrderStatusV1.values()) {
            if (value.getCode().equals(code)) {
                v2Code = value.getV2Code();
                break;
            }
        }
        return v2Code;
    }

    public static OrderStatusV1 getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OrderStatusV1 orderStatus : values()) {
            if (orderStatus.getCode().equals(code)) {
                return orderStatus;
            }
        }
        return null;
    }


    public static Integer[] getAllCodes() {
        Integer[] codeArray = new Integer[values().length];
        int i = 0;
        for (OrderStatusV1 orderStatusV1 : values()) {
            codeArray[i] = orderStatusV1.getCode();
            i++;
        }
        return codeArray;
    }

    OrderStatusV1(String desc, Integer code, Integer v2Code, String descEn) {
        this.desc = desc;
        this.code = code;
        this.v2Code = v2Code;
        this.descEn = descEn;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Integer getV2Code() {
        return v2Code;
    }

    public void setV2Code(Integer v2Code) {
        this.v2Code = v2Code;
    }


    public String getDescEn() {
        return descEn;
    }

    public void setDescEn(String descEn) {
        this.descEn = descEn;
    }
}
