package com.freemud.application.sdk.api.ordercenter.entities.v1;

import lombok.Data;

@Data
public class AddDeliveryInfoV1 {

    /**
     * 配送类型     SELF("self", "自配送"),
     *              THIRD("third", "第三方配送");
     */
    private String deliveryType;
    /**
     * 外卖中台运单号
     */
    private String deliveryId;
    /**
     * 配送公司
     */
    private String express;
    /**
     * 配送公司编号
     */
    private String expressNo;
    /**
     * 运单状态
     * -2默认值 -1:创建失败 0:待接单 1:系统接单 2:分配骑手 3:骑手到店 4:骑手取餐 5:开始配送 6:运单送达 7:运单异常 8:运单取消 9:创建配送单成功
     */
    private Integer deliverStatus;

    private String extInfo;

    /**
     * 下方字段需求来源：C端小程序配送显示骑手、商家坐标地图、配送距离以及骑手姓名电话，支持直接拨打
     * wanghanghang
     * 20210129
     */

    /**
     * 骑手姓名
     */
    private String RiderName;

    /**
     * 骑手电话
     */
    private String RiderPhone;
    /**
     * 订单号
     */
    private String orderId;
    /**
     * 门店联系电话
     */
    private String storePhone;
    /**
     * 骑手经度
     */
    private String riderLongitude;
    /**
     * 骑手纬度
     */
    private String riderLatitude;
    /**
     * 用户经度
     */
    private String destLongitude;
    /**
     * 用户纬度
     */
    private String destLatitude;
    /**
     * 门店经度
     */
    private String shopLongitude;
    /**
     * 门店纬度
     */
    private String shopLatitude;

    /**
     * 骑手与收货人骑行距离
     */
    private Integer distance;

    /**
     * 骑手与收货人之间骑手时间
     */
    private Integer duration;

    /**
     * 骑手与门店骑行距离
     */
    private Long storeDistance;

    /**
     * 骑手与门店之间骑手时间
     */
    private Integer storeDuration;

}
