package com.freemud.application.sdk.api.ordercenter.common;

import com.freemud.application.sdk.api.ordercenter.enums.BizTypeEnum;

import java.util.Objects;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/8/2 下午8:06
 * @description : 订单和 购物车 共同使用方法
 */
public abstract class OrderAndShoppingCommonRedisKey {

    /**
     * 用户购物车在redis的key前缀  爱马哥蛋糕预定
     */
    private final static String SAAS_SHOPPINGCART_AIMAGE_KEY_PREFIX = "saas:user:info:advance:cart:goods:";

    /**
     * 用户购物车在redis的key前缀
     */
    private final static String SAAS_SHOPPINGCART_KEY_PREFIX = "saas:user:info:cart:goods:";

    /**
     * 获取记录购物车信息的key
     *
     * @param partnerId
     * @param storeId
     * @param userId
     * @return
     */
    public static String getShoppingCartGoodsKey(String partnerId, String storeId, String userId,Integer bizType) {
        if(Objects.equals(BizTypeEnum.ADVANCE_ORDER.getBizType(),bizType)){
            return SAAS_SHOPPINGCART_AIMAGE_KEY_PREFIX + partnerId + "_" + storeId + "_" + userId;
        }
        return SAAS_SHOPPINGCART_KEY_PREFIX + partnerId + "_" + storeId + "_" + userId;
    }
}
