/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CustomerExtendClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.management.thirdparty;

import com.freemud.application.sdk.api.ordercenter.entities.vo.OrderCallBackRequestVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "CALL-BACK-SERVICE", url = "${saas.callbackService.feign.url:}")
@RequestMapping(produces = { "application/json;charset=UTF-8" })
public interface OrderCallbackClient {

    /**
     * callback订单
     * @param requestVo
     * @return 无返回值，只有成功或失败
     */
    @PostMapping(value = "/callback/order")
    void callbackOrder(@RequestBody OrderCallBackRequestVo requestVo);
}
