package cn.freemud.management.thirdparty;

import cn.freemud.management.entities.dto.request.pay.PayRefundRequestDto;
import cn.freemud.management.entities.dto.request.pay.PaymentQueryOrderRequestDto;
import cn.freemud.management.entities.dto.response.pay.PayRefundData;
import cn.freemud.management.entities.dto.response.pay.PaymentQueryOrderResponseDto;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OMSPaymentClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: ping1.wu
 * @date: 2019/12/25 19:09
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@FeignClient(name = "payment-center-api",url="${payment.new.baseUrl:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface OMSPaymentClient {

    /**
     * 关闭预支付订单
     */
//    @LogIgnoreFeign(logMessage="payClose")
//    @PostMapping("paymentcenter/close")
//    com.freemud.application.sdk.api.base.BaseResponse<PaymentCloseUnifiedOrderResponse> cancelNewUnifiedOrder(@RequestBody PaymentCloseUnifiedOrderRequest request);

    /**
     * 支付查询
     */
//    @LogIgnoreFeign(logMessage="payQuery")
//    @PostMapping("paymentcenter/query")
//    com.freemud.application.sdk.api.base.BaseResponse<PaymentQueryResponseDto> payQuery(@RequestBody PaymentQueryRequestDto request);

    /**
     * 支付退款查询
     */
    @LogIgnoreFeign(logMessage="payQueryOrder")
    @PostMapping("paymentcenter/queryOrder")
    BaseResponse<PaymentQueryOrderResponseDto> payQueryOrder(@RequestBody PaymentQueryOrderRequestDto request);

    /**
     * 现金支付退款接口
     */
    @LogIgnoreFeign(logMessage="payRefund")
    @PostMapping("paymentcenter/refund")
    BaseResponse<PayRefundData> payRefund(@RequestBody PayRefundRequestDto request);
}
