package cn.freemud.management.service.handle;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.RefundModeEnum;
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.request.order.CancelOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.BaseOrderResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: SaasOrderService
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/23 11:30
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class MallOrderHandle {

    @Autowired
    private OrderSdkAdapter orderSdkAdapter;
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;

    @Value("${saasDeliveryTimeOut}")
    private Integer wmDeliveryTimeOut;

    /**
     * 同意退款
     *
     * @param request
     * @param refundResponse
     * @param orderBean
     * @return
     */
    public BaseResponse refundAgree(OrderManagerRequest request, PayRefundResponse refundResponse, OrderBeanV1 orderBean) {
        BaseQueryOrderRequest refundAgreeRequest = orderSdkAdapter.getRefundAgreeRequest(refundResponse.getRefundId(), request.getReason(), request.getOperator(), orderBean);
        BaseOrderResponse baseOrderResponse = null;
        if (PayRefundStatus.SUCCESS.equals(refundResponse.getPayRefundStatus()) && RefundModeEnum.REFUND_ALL.getIndex() == orderBean.getRefundList().get(0).getRefundMode()) {
            baseOrderResponse = orderCenterSdkService.mallOrderRefundComplete(refundAgreeRequest);
        }else if(PayRefundStatus.SUCCESS.equals(refundResponse.getPayRefundStatus()) && RefundModeEnum.UN_REFUND_GOODS.getIndex() == orderBean.getRefundList().get(0).getRefundMode()){
            baseOrderResponse = orderCenterSdkService.adultApproveWithRefundComplete(refundAgreeRequest);
        }
        else {
            baseOrderResponse = orderCenterSdkService.mallOrderRefundReturn(refundAgreeRequest);
        }
        if (baseOrderResponse == null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), baseOrderResponse.getErrcode().toString())) {
            return ResponseUtil.error(ResponseResult.AGREE_REFUND_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse refundReject(OrderManagerRequest request, OrderBeanV1 orderBean) {
        CancelOrderRequest rejectRefundRequest = orderSdkAdapter.getRejectRefundRequest(request.getOperator(), request.getReason(), orderBean);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderRefundReject(rejectRefundRequest);
        if (baseOrderResponse == null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), baseOrderResponse.getErrcode().toString())) {
            return ResponseUtil.error(ResponseResult.REJECT_REFUND_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 同意退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse mallOrderAgreeApply(OrderManagerRequest request, OrderBeanV1 orderBean) {
        BaseQueryOrderRequest refundAgreeRequest = orderSdkAdapter.getRefundAgreeRequest("", request.getReason(), request.getOperator(), orderBean);
        BaseOrderResponse baseOrderResponse  = orderCenterSdkService.mallOrderAgreeApply(refundAgreeRequest);
        if (baseOrderResponse == null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), baseOrderResponse.getErrcode().toString())) {
            return ResponseUtil.error(ResponseResult.AGREE_REFUND_APPLY_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse mallRefundReject(OrderManagerRequest request, OrderBeanV1 orderBean) {
        CancelOrderRequest rejectRefundRequest = orderSdkAdapter.getRejectRefundRequest(request.getOperator(), request.getReason(), orderBean);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.mallOrderRefundReject(rejectRefundRequest);
        if (baseOrderResponse == null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), baseOrderResponse.getErrcode().toString())) {
            return ResponseUtil.error(ResponseResult.REJECT_REFUND_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒单
     *
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse mallOrderReject(OrderManagerRequest request, PayRefundResponse refundResponse, OrderBeanV1 orderBean) {
        //作废订单
        CancelOrderRequest cancelOrderRequest = orderSdkAdapter.getCancelOrderRequest(request.getOperator(), request.getReason(), refundResponse.getPayRefundStatus(), refundResponse.getRefundId(), orderBean);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.mallOrderReject(cancelOrderRequest);
        if (baseOrderResponse == null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), baseOrderResponse.getErrcode().toString())) {
            return ResponseUtil.error(ResponseResult.AFFIRM_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

}
