package cn.freemud.management.enums;

import org.apache.commons.lang.StringUtils;

public enum McCafeOperateType {

    ORDER_SUCCESS("orderSuccess","入机成功"),
    ORDER_REFUND("orderRefund","入机失败");


    /**
     * 操作类型
     */
    private String opType;
    /**
     * 操作名称
     */
    private String opName;

    McCafeOperateType(String opType, String opName) {
        this.opType = opType;
        this.opName = opName;
    }

    public String getOpType() {
        return opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public String getOpName() {
        return opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public static McCafeOperateType getByOpType(String opType){
        if (StringUtils.isEmpty(opType)) {
            return null;
        }
        for (McCafeOperateType operateType : values()) {
            if (operateType.getOpType().equals(opType)) {
                return operateType;
            }
        }
        return null;

    }
}
