package cn.freemud.management.entities.dto.request.order;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MCCafeCouponRequest {
    /**
     * 接口版本
     */
    @NotNull
    private Integer ver;

    /**
     * kdg.Y 开个店渠道且需要回调三方
     * kgd.N 开个店渠道且不需要回调三方
     */
    private String appFlag;
    /**
     * 需要查询的券码，仅供查询券使用
     */
    private String coupon;
    /**
     * 请求操作类型，0是卡券查询，2是卡券交易查询，3是卡券冲正，71是卡券核销
     */
    @NotNull(message = "操作不能为空")
    private Integer reqtype;
    /**
     * 商家门店号
     */
    @NotBlank(message = "商家门店号不能为空")
    private String store_id;

    /**
     * 子品牌 ID 可以为空
     */
    private String organize_id;

    /**
     * 组织机构ID(注意和channle的区别)
     */
    private List<String> channel_ids;

    /**
     * 组织机构code(注意和channle的区别)
     */
    private List<String> channel_codes;

    /**
     * 商家POS机编号
     */
    @NotBlank(message = "商家POS机编号不能为空")
    private String station_id;
    /**
     * 营业员编号
     */
    @NotBlank(message = "营业员编号不能为空")
    private String operator_id;
    /**
     * 商户编号
     */
    @NotNull(message = "商户编号不能为空")
    private Integer partnerId;

    private Integer checkValue;

    private Integer clientReqCount;
    /**
     * POS交易序号
     */
    private String trans_id;
    /**
     * 营业日
     */
    private String business_date;
    /**
     * 优惠券列表
     */
    private List<MCCafeTransactionVo> transactions;
    /**
     * 签名
     */
    private String sign;
    /**
     * 追加key
     */
    private String appSecret;

    private String openid;

    private String transactionuuid;

    private String status;

    private Boolean isManual;

    private String channel;

    private List<MCCafeCouponVo> couponlist;

    private MemberInfo memberInfo;

    @Data
    @AllArgsConstructor
    public static class MemberInfo {
        private String memberId;

        private String appId;

        private String unionId;

        private String thirdPartyMemberId;

        /**
         * 自提："mccafe_pickup"
         * 外卖: "mccafe"
         */
        private String tag;
    }
}
