package cn.freemud.management.entities.dto.request;

import lombok.Data;
import lombok.ToString;

import java.util.List;

@Data
public class BatchOrderRefundV2Request {

    /**
     * 退款订单列表信息
     */
    private List<BatchOrderRefundItem> batchSubRefundRequest;

    /**
     * 退款回调地址
     */
    private String notifyUrl;

    /**
     * 商户编号（由非码提供）
     */
    private String partnerId;

    /**
     * 商家门店号（在线支付需要提前定义）
     */
    private String storeId;

    /**
     * 商家POS机编号（可以使用固定值）
     */
    private String stationId;

    /**
     * 接口版本，必须为2
     */
    private String ver;


    /**
     * 退款订单信息
     */
    @Data
    public static class BatchOrderRefundItem {
        /**
         * 非码订单号
         */
        private String fmId;

        /**
         * 外部交易流水号，由上游系统生成，需保证唯一(支付标识)
         */
        private String frontTransId;

        /**
         * 退款金额
         */
        private Long refundAmount;
    }
}
