package cn.freemud.service.impl;

import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.entities.dto.StoreResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.service.adapter.OrderManagerAdapter;
import cn.freemud.management.thirdparty.MulitiPaymentClient;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.delivery.ThirdDeliveryServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformConfig;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerConfig;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformConfigManager;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformPartnerConfigManager;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.ordercenter.service.OrderDownLoadSdkService;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.test.context.junit4.SpringRunner;
import springfox.documentation.spring.web.json.Json;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import java.sql.SQLException;
import java.util.Set;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MallOrderServiceImplTest {

    @Autowired
    private AssortmentOpenPlatformPartnerConfigManager assortmentOpenPlatformPartnerConfigManager;

//    @Autowired
//    private MallOrderServiceImpl mallOrderService;
//
    @Autowired
    private MCCafeOrderServiceImpl mcCafeOrderService;
//
//    @Autowired
//    private MulitiPaymentClient mulitiPaymentClient;
//
//    @Autowired
//    private OrderManagerAdapter orderManagerAdapter;

//    @Before
//    public void before() throws Exception {
//    }
//
//    @After
//    public void after() throws Exception {
//    }

    @Autowired
    private ApplicationContext applicationContext;

    @Test
    public void f1() {
        mcCafeOrderService.createOrder(JSON.parseObject("{\"buyType\":0,\"cardKeyCode\":\"509835\",\"channelType\":\"saas\",\"couponCode\":\"\",\"menuType\":\"saas\",\"needInvoice\":1,\"orderRemark\":\"\",\"orderType\":1,\"partnerId\":\"1628\",\"payChannelType\":1,\"receiveId\":\"\",\"sessionId\":\"18459edce0b4c5a5794e855b988d45e0b54ba705\",\"shopId\":\"1950512\",\"takeMealFlag\":\"0\"}", CreateOrderVo.class),
                new StoreResponseDto(),
                JSON.parseObject("{\"activityDiscountsDtos\":[{\"activityCode\":\"618535339440866\",\"activityName\":\"五元冰中杯拿铁\",\"activityType\":32,\"cartGoodsUid\":\"\",\"discountAmount\":0,\"extendType\":0},{\"activityCode\":\"601817311288933\",\"activityName\":\"麦咖啡6折月卡\",\"activityType\":38,\"cartGoodsUid\":\"\",\"discountAmount\":0,\"extendType\":12}],\"deliveryAmount\":0,\"discountDeliveryAmount\":0,\"isDiscountDelivery\":false,\"monthCardDiscount\":{\"couponCode\":\"601817311288933\",\"discountAmount\":0,\"discountDesc\":\"麦咖啡6折月卡\",\"discountLogo\":\"https://img0.sandload.cn/mcd_4ac948fb-e271-495c-8b59-02a2552b0385.png\"},\"originalTotalAmount\":1490,\"packageAmount\":0,\"payCardFee\":0,\"products\":[{\"activityDiscountsDtos\":[{\"activityCode\":\"618535339440866\",\"activityName\":\"五元冰中杯拿铁\",\"activityType\":32,\"discountAmount\":0,\"extendType\":0,\"tenderId\":\"510097\"}],\"attributeNames\":\"{\\\"attributeForeignNames\\\":\\\"\\\",\\\"attributeNames\\\":\\\"\\\"}\",\"cartGoodsUid\":\"fba23e82-f373-4efe-b269-3f894b7518d9\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"attributeNames\":\"{\\\"attributeForeignNames\\\":\\\"\\\",\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"4284\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isFixedProduct\":true,\"isMonthCard\":0,\"isTableware\":0,\"materialList\":[],\"originalPrice\":1900,\"parentProductId\":\"204906623301330748\",\"picture\":\"https://picture.sandload.cn/1608184940077.png\",\"productType\":6,\"qty\":1,\"skuId\":\"190075426702468663\",\"skuName\":\"冰拿铁中杯\",\"spuName\":\"冰拿铁中杯\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"couponCode\":\"618535339440866\",\"customerCode\":\"510097\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isTableware\":0,\"materialList\":[],\"originalPrice\":500,\"picture\":\"https://picture.sandload.cn/1625639691765.png\",\"productCode\":\"510097\",\"productType\":6,\"qty\":1,\"skuId\":\"204906623301330748\",\"skuName\":\"五元冰中杯拿铁\",\"spuId\":\"204906623301330748\",\"spuName\":\"五元冰中杯拿铁\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"activityDiscountsDtos\":[],\"attributeNames\":\"{\\\"attributeForeignNames\\\":\\\"\\\",\\\"attributeNames\\\":\\\"\\\"}\",\"cartGoodsUid\":\"f6ef0233-9801-4eb5-b6c4-62edd9070ec4\",\"classificationId\":\"\",\"classificationName\":\"\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":1,\"isTableware\":0,\"materialList\":[],\"monthCardInfo\":{\"cardCode\":\"601817311288933\",\"cardNo\":\"MQYK4872D6896B41011BAEFD21C5C557F0A1\"},\"originalPrice\":990,\"picture\":\"https://picture.sandload.cn/1618542683267.png\",\"productCode\":\"509835\",\"productType\":9,\"qty\":1,\"skuId\":\"205155790621999679\",\"skuName\":\"麦咖啡6折月卡\",\"spuId\":\"205155790621999679\",\"spuName\":\"麦咖啡6折月卡\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"26\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"totalAmount\":1490,\"totalDiscountAmount\":0}", ShoppingCartGoodsDto.class),
                new OrderExtendedReq(),
                OrderClientType.SAAS,"www");
    }

    @Test
    public void f2() {
        HibernateValidatorConfiguration configuration = Validation.byProvider(HibernateValidator.class)
                .configure()
                .failFast(false);
        ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
        Set<ConstraintViolation<CreateOrderVo>> set = validatorFactory.getValidator().validate(new CreateOrderVo());
    }

    @Test
    public void f3() throws SQLException {
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory) applicationContext.getBean("sqlSessionFactory");
        SqlSessionFactory db2SqlSessionFactory = (SqlSessionFactory) applicationContext.getBean("db2SqlSessionFactory");
        return;
    }

//
//    @Test
//    public void testPaySuccess() {
//        //0元支付
//        String fmId = "SPAY" + ValidationCode.getRandomUuid();
//        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
//        message.setResult_code(100);
//        message.setOut_trade_no(fmId);
//        message.setTrans_id("16303606485084241800003");
//        message.setTotal_fee(0);
//        message.setOpenid("oORZK5MHMBm78PO302NdRyzIY5K0");
//        message.setPlatform_coupon(0);
//        message.setMerchant_coupon(0);
//        mallOrderService.paySuccessCallback(message);
//    }

//    @Test
//    public void testAffirm() {
//        OrderAffirmRequestVO requestVO = new OrderAffirmRequestVO();
//        requestVO.setPartnerId("1864");
//        requestVO.setShopId("8899");
//        requestVO.setSessionId("123123");
//        requestVO.setChannelType("saasmall");
//        requestVO.setOid("16303606485084241800003");
//        mallOrderService.orderAffirm(requestVO);
//    }

    @Test
    public void test() {
        String payTurnoffRefund = "0";
        try {
            AssortmentOpenPlatformPartnerConfig assortmentOpenPlatformPartnerConfig = assortmentOpenPlatformPartnerConfigManager.selectPartnerConfigByPartnerKey("0",RedisKeyConstant.PARTNER_PAY_TURNOFF_REFUND,1);
            if (null != assortmentOpenPlatformPartnerConfig) {
                payTurnoffRefund = assortmentOpenPlatformPartnerConfig.getPartnerValue();
            }
        }catch (Exception e){

        }
        System.out.println(payTurnoffRefund);
    }
}
