package cn.freemud.amp.service;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Setter
@Getter
public class AuditScoreAccount {

    /**
     * 账本主键ID
     */
    private String accountId;

    private String partnerId;

    private String memberId;

    /**
     * 账本状态{1可使用 2已使用}
     */
    private Integer accountStatus;

    /**
     * 源积分值
     */
    private Integer originScore;

    /**
     * 剩余积分值
     */
    private Integer leftScore;

    /**
     * 到日日期{格式：yyyy-MM-dd}
     */
    private String expireDate;

    /*
    所属机构类型{1总公司2分公司3门店}
     */
    private Integer orgType;

    /**
     * 所属机构编码
     */
    private String orgCode;

    /**
     * 所属机构类型{1总公司2分公司3门店}
     */
    private Integer belongOrgType;

    /**
     * 所属机构编码
     */
    private String belongOrgCode;

    private Date createTime;

    private Date updateTime;

    /**
     * 是否删除{0表示否 1表示是}
     */
    private Integer isDel;

    @Override
    public String toString() {
        return this.accountId;
    }
}