package cn.freemud.controller;

import cn.freemud.OrderApplication;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.CreateSpellGroupOrderReq;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * @author freemud
 * @title: SpellGroupOrderControllerTest
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/16下午3:58
 */


@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderApplication.class)
public class SpellGroupOrderControllerTest {

    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 创建订单
     */
    @Test
    public void createOrder() {
        CreateSpellGroupOrderReq createSpellGroupOrderReq = new CreateSpellGroupOrderReq();
//        createSpellGroupOrderReq.setSessionId();
//        createSpellGroupOrderReq.setSpellGroupCode();
//        createSpellGroupOrderReq.setStoreId("3536");
//        createSpellGroupOrderReq.setPartnerId("1864");
//        createSpellGroupOrderReq.setMenuType();
//        createSpellGroupOrderReq.setChannelType();
//        createSpellGroupOrderReq.setOrderClient();
//        createSpellGroupOrderReq.setPayChannelType();
//        createSpellGroupOrderReq.setOrderType();
//        createSpellGroupOrderReq.setMarketingType();
//        createSpellGroupOrderReq.setReceiveId();
//        createSpellGroupOrderReq.setActivityCode();
//        createSpellGroupOrderReq.setSpellGroupProductList();
//        createSpellGroupOrderReq.setOrderRemark();


        String str = JSONObject.toJSONString(createSpellGroupOrderReq);
        try {
            mockMvc.perform(post("/order/createSpellGroupOrder").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
