/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: WeChatClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/29 16:10
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import com.freemud.sdk.api.assortment.order.request.order.GroupBuyRequest;
import com.freemud.sdk.api.assortment.order.response.order.GroupBuyResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "WECHAT-SERVICE", url = "${saas.wechatclient.feign.url}")
public interface WeChatClient {

    /**
     * 发起群收款
     */
    @PostMapping(value = "wxa/business/groupBuy/createOrder?access_token={accessToken}",
            produces = MediaType.APPLICATION_JSON_VALUE,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @LogIgnoreFeign(logMessage="groupBuyCreateOrder",messageFieldName= ResponseCodeKeyConstant.ERR_MSG,statusCodeFieldName=ResponseCodeKeyConstant.ERR_CODE)
    GroupBuyResponse groupBuyCreateOrder(@PathVariable("accessToken") String accessToken, @RequestBody GroupBuyRequest groupBuyRequest);

}
