package cn.freemud.service.thirdparty;

import cn.freemud.entities.EdenResponse;
import cn.freemud.entities.dto.pay.svc.ConsumeHistoryCreateRequest;
import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @Auther: hujx
 * @Description: 储值交易服务
 * @CreateDate: Created in 10:31 2020/3/19
 * @ModifyDate:
 */
@FeignClient(name = "transaction-svc-application", url = "${fm.svcTransaction.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface SvcTransactionClient {

    /**
     * 储值卡订单消费后通知储值交易服务
     */
    @PostMapping(value = "/svc/rechargeHistory/reduce")
    @LogIgnoreFeign(logMessage="consumeHistoryCreate")
    EdenResponse consumeHistoryCreate(ConsumeHistoryCreateRequest request);

}
