package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.openplatform.PushOrderStoreDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/5/10 下午5:45
 * @description :
 */
@FeignClient(name = "STORE-BACKSTAGE")
@RequestMapping(consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface StoreBackstageClient {

    @LogIgnoreFeign(logMessage="pushOrderStore")
    @PostMapping("/orderStore/pushOrderStore")
    BaseResponse pushOrderStore(@RequestBody PushOrderStoreDto request);

}
