package cn.freemud.service.thirdparty;


import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.product.pointsmall.IntegralProductType;
import cn.freemud.entities.dto.product.pointsmall.PointMallListProductInfoRequest;
import cn.freemud.entities.dto.product.pointsmall.PointMallListProductInfoResponse;
import cn.freemud.entities.dto.product.pointsmall.UpdatePointsMallStocksRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "INTEGRAL-MALL-SERVICE", url = "${ssas.integralMall.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PointMallProductClient {


    /**
     * 获取商品的详细信息
     */
    @LogIgnoreFeign(logMessage="listProductInfos",statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/biz/product/listProductInfo")
    PointMallListProductInfoResponse<List<IntegralProductType>> listProductInfo(@RequestBody PointMallListProductInfoRequest productInfoRequest);


    @LogIgnoreFeign(logMessage="listProductInfos",statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("/biz/stock/update")
    PointMallListProductInfoResponse updateStock(@RequestBody UpdatePointsMallStocksRequest updatePointsMallStocksRequest);


}
