package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.blacklist.Result;
import cn.freemud.entities.dto.blacklist.req.BlackListQueryByClient;
import cn.freemud.entities.dto.blacklist.resp.MemberBlacklistVO;
import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/5/27 14:17
 * @description :
 */
@FeignClient(name = "data-center")
@RequestMapping(produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public interface DataCenterClient {

    /**
     * 查询用户是否在黑名单中
     */
    @LogIgnoreFeign(logMessage="queryByMemberId")
    @PostMapping("/blacklist/query-by-memberId")
    Result<MemberBlacklistVO> queryByMemberId(@RequestBody BlackListQueryByClient req);

}
