/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreItemStatus
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/14 10:45
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum StoreItemStatus {

    PULL_OFF(1, "下架"),
    PUT_ON_SALE(2, "上架"),
    SELL_OUT(3, "售罄");

    private Integer code;

    private String desc;

    StoreItemStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static StoreItemStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (StoreItemStatus storeItemStatus : values()) {
            if (storeItemStatus.getCode().equals(code)) {
                return storeItemStatus;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
