/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderStatus
 * @Package cn.freemud.enums
 * @Description: 查询订单状态
 * @author: liming.guo
 * @date: 2018/5/22 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.enums;

public enum QueryOrderStatus {

    TAKE_MEAL(1, "待取餐"),
    FINISH(2, "已完成"),
    ALL_BILL(3, "全部"),
    REFUND_BILL(4, "退款"),
    NO_PAY(5, "待支付"),
    ORDER_CANCEL(6, "已取消"),
    //密雪
    ORDER_CANCEL_MIXUE(7, "未支付已取消"),

    // 美业专用
    WAIT_USE(8, "待使用");


    private Integer code;

    private String desc;

    QueryOrderStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static QueryOrderStatus getByCode(Integer code) {
        for (QueryOrderStatus status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
