package cn.freemud.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 补偿状态
 */
@Getter
public enum OrderResourcePushOptType {

    COUPON_LOCK(11, "券锁定"),
    COUPON_VERIFICATION(12, "券核销"),
    COUPON_RECTIFICATION(13, "券冲正"),
    Score_SEND(21, "积分发放"),
    Score_RECTIFICATION(22, "积分冲正"),
    POINT_SEND(31, "集点发放"),
    POINT_RECTIFICATION(32, "集点冲正"),
    ;

    private final Integer index;
    private final String name;

    OrderResourcePushOptType(Integer index, String name) {
        this.index = index;
        this.name = name;
    }


    private static class EnumCacheHolder {
        private static final Map<Integer, OrderResourcePushOptType> CACHE;

        static {
            CACHE = Arrays.stream(OrderResourcePushOptType.values()).collect(Collectors.toMap(OrderResourcePushOptType::getIndex, v -> v));
        }
    }

    public static OrderResourcePushOptType getByIndex(Integer index) {
        return EnumCacheHolder.CACHE.get(index);
    }

    public static OrderResourcePushOptType getByIndexOrDefault(Byte index, OrderResourcePushOptType defaultEnum) {
        OrderResourcePushOptType en = EnumCacheHolder.CACHE.get(index);
        return en == null ? defaultEnum : en;
    }
}
