package cn.freemud.enums;

import lombok.Getter;

@Getter
public enum  MessageEventTypeEnum {

    INSTANT_ORDER_PAYED(30, "INSTANT_ORDER_PAYED", "即时单下单成功通知"),
    BOOKING_ORDER_PAYED(31, "BOOKING_ORDER_PAYED", "预约单下单成功通知"),
    SELF_DELIVERY_ORDER_PAYED(32, "SELF_DELIVERY_ORDER_PAYED", "自配送下单成功通知"),
    ORDER_DELIVERY(33, "ORDER_DELIVERY", "订单配送通知"),
    BOOKING_ORDER_TAKE_REMINDER(34, "BOOKING_ORDER_TAKE_REMINDER", "预约单取单通知"),
    INSTANT_ORDER_TAKE_REMINDER(35, "INSTANT_ORDER_TAKE_REMINDER", "即时单取单通知"),
    GROUP_BUYING_STATUS_REMINDER(36, "GROUP_BUYING_STATUS_REMINDER", "拼单提醒"),
    DELIVERY_ERROR_REMINDER(37, "DELIVERY_ERROR_REMINDER", "配送异常提醒"),


    MCCAFE_PICKUP_FOOD(40, "MCCAFE_PICKUP_FOOD", "麦咖啡取餐提醒"),
    MCCAFE_DELIVERY_ORDER(41, "MCCAFE_DELIVERY_ORDER", "麦咖啡订单配送通知"),
    MCCAFE_COMPLETE_ORDER(42, "MCCAFE_COMPLETE_ORDER", "麦咖啡订单完成通知"),
    MCCAFE_TRANSACTION_REMINDER(43, "MCCAFE_TRANSACTION_REMINDER", "麦咖啡交易提醒"),


    ;



    private int code;
    private String type;
    private String name;

    MessageEventTypeEnum(int code, String type,String name) {
        this.code = code;
        this.type = type;
        this.name = name;
    }

}
