package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.enums OrderTypeGather
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/5/7
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum McCafeOrderTypeGather {
    TAKE_OUT(1, "外卖"),
    PRE_ORDER(2, "预订单"),
    COLLECT_GOODS(4, "打包"),
    EAT_IN(5, "堂食");

    private Integer code;
    private String desc;
    //订单服务订单类型 1=外卖 4=自提，5=堂食
    //外卖平台订单类型 1=常规堂食，2=预约堂食，3=常规外送，4=预约外送，5=常规自取，6=预约自取
    McCafeOrderTypeGather(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static McCafeOrderTypeGather getByCode(Integer code) {
        if (code==null) {
            return null;
        }
        for (McCafeOrderTypeGather orderTypeGather : values()) {
            if (orderTypeGather.getCode().equals(code)) {
                return orderTypeGather;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
