package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponTradeChannelEnum
 * @Package cn.freemud.enums
 * @Description:
 * @author: bowen.hu
 * @date: 2021-10-20 15:36
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public enum CouponTradeChannelEnum {


    WX_TRADE_CHANNEL("WX_TRADE_CHANNEL", "1", "微信交易渠道"),
    OTHER_TRADE_CHANNEL("WX_TRADE_CHANNEL", "", "其他交易渠道"),
    ALIPAY_TRADE_CHANNEL("ZHIFUBAO_TRADE_CHANNEL", "2", "支付宝渠道");


    private String tradeChannel;

    private String orderClient;

    private String desc;

    CouponTradeChannelEnum(String tradeChannel, String orderClient, String desc) {
        this.tradeChannel = tradeChannel;
        this.orderClient = orderClient;
        this.desc = desc;
    }

    public String getTradeChannel() {
        return tradeChannel;
    }

    public String getOrderClient() {
        return orderClient;
    }

    public String getDesc() {
        return desc;
    }


    public static String getCouponChannel(String orderClient) {
        CouponTradeChannelEnum[] values = CouponTradeChannelEnum.values();
        for (CouponTradeChannelEnum tradeChannelEnum : values) {
            if (tradeChannelEnum.getOrderClient().equals(orderClient)) {
                return  tradeChannelEnum.getTradeChannel();
            }
        }

        return CouponTradeChannelEnum.OTHER_TRADE_CHANNEL.getTradeChannel();

    }

}
