package cn.freemud.enums;

public enum CouponOrderRefundStatusEnum {

    WAIT(1, "待退款"),
    REFUNDED(2, "已退款"),
    REFUND_FAILED(3, "退款失败"),
    NOT_NEED_REFUND(4, "无需退款"),
    ;

    private Integer code;
    private String desc;

    CouponOrderRefundStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponOrderRefundStatusEnum getByCode(Integer code) {
        for (CouponOrderRefundStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
