package cn.freemud.enums;

/**
 * @author freemud
 * @title: ActivityGroupStatusEnum
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/27下午6:01
 */
public enum ActivityGroupStatusEnum {

    NORMAL(1,"正常"),
    INSUFFICIENT_INVENTORY(2,"库存不足"),
    UPPER_LIMIT_OF_NUMBE(3,"您参与次数达到上限"),
    GROUP_HAS_FAILURE(4,"团已失效"),
    NUMBER_HAS_REACHED(5,"拼团活动人数已满"),
    ACTIVITY_DOES_NOT_EXIST(6,"活动不存在")
    ;
    private Integer code;
    private String desc;
    ActivityGroupStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    public static ActivityGroupStatusEnum getByCode(Integer code) {
        for (ActivityGroupStatusEnum activityGroupStatusEnum : values()) {
            if (activityGroupStatusEnum.getCode().equals(code)) {
                return activityGroupStatusEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
