package cn.freemud.entities.vo.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author Clover.z
 * @Date 2021/10/19
 * @Desc 创建无单订单请求报文实体
 */
@Data
public class CreateCashierOrderVo {

    /**
     * 用户登陆的session
     */
    @ApiModelProperty("用户登陆的session")
    @NotEmpty(message = "请先授权登陆")
    private String sessionId;

    /**
     * 商户号
     */
    @ApiModelProperty("商户号")
    @NotEmpty(message = "商户号必填")
    private String partnerId;

    /**
     * 门店号
     */
    @ApiModelProperty("门店号")
    @NotEmpty(message = "门店号必填")
    private String storeCode;

    /**
     * 订单金额（单位：分）
     */
    @ApiModelProperty("订单金额（单位：分）")
    @NotNull(message = "请输入订单金额")
    @Min(value = 1, message = "请输入有效的订单金额哟")
    private Long orderAmount;

    /**
     * 储值卡卡号
     */
    @ApiModelProperty("储值卡卡号")
    private String cardCode;

    /**
     * 小程序版本号
     */
    @ApiModelProperty("小程序版本号")
    private String version;
}
