package cn.freemud.entities.vo.mccafe;

import cn.freemud.entities.vo.CartGoods;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2021-01-26 09:50:21
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class RecentGoodsInfoVo {
    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;

    /**
     * 数量
     */
    @NotNull(message = "商品数量不可为空")
    private Integer qty;

    /**
     * 商品的spuName
     */
    private String spuName;

    /**
     * 商品的skuName
     */
    private String skuName;
    /**
     * 套餐固定商品
     */
    private List<ComboGoodsVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboGoodsVo> productGroupList;

    /**
     * 加料
     */
    private List<MaterialGoodsVo> productMaterialList;

    /**
     * 麦咖啡定制属性
     */
    private List<SpecialExtra> specialExtra;

    @Data
    public final static class ComboGoodsVo {

        /**
         * 麦咖啡多规格商品spuid
         */
        private String spuId;

        private String skuId;
        private String productGroupId;

        /**
         * 商品的spuName
         */
        private String spuName;

        /**
         * 商品的skuName
         */
        private String skuName;
        private Integer qty;

        private List<SpecialExtra> specialExtra;

        /**
         * 麦咖啡多规格商品加料
         */
        private List<MaterialGoodsVo> productMaterialList;

    }

    @Data
    public final static class MaterialGoodsVo {
        /**
         * 加料商品ID
         */
        private String spuId;
        private String spuName;

        /**
         * 数量
         */
        private Integer qty;

        /**
         * 麦咖啡入机键位
         */
        private String customerCode;

    }

    @Data
    public final static class SpecialExtra {
        /**
         * 属性Id
         */
        private String attributeId;
        /**
         * 属性名
         */
        private String attributeName;
        private String attributeForeignName;


        /**
         * 麦咖啡特定属性入机code
         */
        private String specialCode;
    }
}
