package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: SellCouponCreateOrderVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping1.wu
 * @date: 2020/5/21 17:27
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SellCouponCreateOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

//    @NotEmpty(message = "shopId 门店号不能为空")
    private String shopId;

    //一键买券必传
    @NotEmpty(message = "skuId 不能为空")
    private String skuId;

    /**
     * svc 储值卡支付使用
     */
    private String cardCode;

    @NotEmpty(message = "menuType 不能为空")
    private String menuType;

    /**
     * form_id  用于金额是0的情况，支付宝模板消息需要传
     */
    private String formId;

    /**
     * 业务类型
     */
    @NotEmpty(message = "bizType 业务类型不能为空")
    private String bizType;

    /**
     * 版本号
     */
//    @NotEmpty(message = "version 版本号不能为空")
    private String version;


    /**
     * 渠道 1 saas 2 img 爱马哥  默认saas 3. iwc i围餐
     */
    private String channel;

    /**
     * 【华莱士】【订单C端记录不分账的卡面编号】不让走分账，卡面编号--11840，11845，11846，11853，11854，11855，11857，11858，11859，11860，11861，11862，11863，11864，11865，11866，11906
     * <p>
     * 1 表示不分账 ,其他情况 不传值 给基础服务
     */
//    private Integer unDistribution;


    /**
     * 视频卖券 需要带上该参数
     * 卖券场景值
     */
    private String scene;


}
