package cn.freemud.entities.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class QueryInvoiceRep {

    //C端
    private Date createTime;//开票日期
    private Integer invoiceType;//发票类型,004：增值税专用发票；007：增值税普通发票；026：增 值税电子发票；025：增值税卷式发票；028:增值税专用电子发票（万象）
    private Integer amount;//发票金额，单位是分（聚合：所有订单实付金额）
    private Integer orderQuantity;//订单数量

    //补充
    private String invoiceNo;//开票流水号（聚合：流水号有意义）
    private BigDecimal taxRate;//税率（统一写死：6%）
    private String taxNo;//销方机构税号（万象）
    private String goodsLineNo;//明细行号（按百望要求的规则：01）
    private String goodsName;//商品名称（统一写死：餐饮服务）
    private String goodsCode;//税收分类编码（统一写死：3070401000000000000）

    //百望返回
    private String invoiceUrl;//前端重定向，发票URL地址
    private String randomCode;//提取码
    private String invoiceId;//发票id
    private Date endingDate;//开票截至时间

}
