package cn.freemud.entities.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * 订单状态监控信息
 *
 * @version: 1.0
 * @Description: TODO
 * @author: WangShiChang
 * @date: 2021/5/13 下午4:36
 * @Copyright: www.freemud.cn Inc.
 */
@Data
public class OrderStateMonitorInfoVo implements Serializable {
    private static final long serialVersionUID = 2840452799139432761L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单状态
     */
    private Integer orderState;

    /**
     * 状态超时时间
     */
    private Long stateTimeout;

    /**
     * 是否需要监控
     * 默认false
     */
    private Boolean needMonitor;


    /**
     * 更新时间戳
     */
    private Long updateTimestamp;

    public Boolean getNeedMonitor() {
        // 默认false
        return Objects.isNull(needMonitor) ? Boolean.FALSE : Boolean.TRUE;
    }

}
