package cn.freemud.entities.vo;

import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Comparator;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderProductComboxVo
 * @Package cn.freemud.entities
 * @Description:
 * @author: ping1.wu
 * @date: 2020/4/23 16:16
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class OrderProductComboxVo {

    /**
     * 单规格spuId,多规格skuId
     */
    private String goodsId;
    private String skuId;
    private String skuName;
    /**
     * 所有属性attributeId的拼接
     */
    private String specProductId;
    /**
     * 购物车一行商品的原单机
     */
    private Long originalPrice;
    /**
     * 购物车一行商品的现售单价
     */
    private Long finalPrice;

    /**
     * 购物车一行商品的包装费
     */
    private Long packPrice;

    /**
     * 购物车一行商品的原价
     */
    private Long originalAmount;

    /**
     * 购物车一行商品的现价
     */
    private Long amount;
    /**
     * 购物车一行商品的数量
     */
    private Integer qty;
    /**
     * 购物车一行商品的名称
     */
    private String name;

    /**
     * 商品的spuName
     */
    private String spuName;
    /**
     * 购物车一行商品的副名称
     */
    private String subName;
    /**
     * 商品图片URL
     */
    private String pic;
    /**
     * 配料或属性
     */
    private List<OrderProductExtraVo> extra;
    /**
     * 1:称重菜
     */
    private boolean weightType;
    /**
     * 重量
     */
    private Double weight;
    /**
     * 单位
     */
    private String unit;
    /**
     * 第三方商品编号
     */
    private String customerCode;
    /**
     * 商品组Id
     */
    private Long productGroupId;

    @Override
    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(goodsId);
        if (CollectionUtils.isNotEmpty(extra)) {
            extra.stream().sorted(Comparator.comparing(OrderProductExtraVo::getAttributeId)).forEach(e -> sb.append(e.getAttributeId()));
        }
        return sb.toString().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(goodsId);
        if (CollectionUtils.isNotEmpty(extra)) {
            extra.stream().sorted(Comparator.comparing(OrderProductExtraVo::getAttributeId)).forEach(e -> sb.append(e.getAttributeId()));
        }
        return sb.toString();
    }

}
