package cn.freemud.entities.vo;

import com.freemud.application.sdk.api.ordercenter.enums.RefundModeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/4/30 15:03
 * @description :
 */
@Data
public class OrderDevelopRefundVo {
    /**
     * 订单号
     */
    private List<String> orderCodes;

    private String partnerId;

    /**
     * 退款理由
     */
    private String reason;

    /**
     * 操作人,需要记录操作人
     */
    @NotBlank(message = "请真实填写调动该接口的操作人")
    private String operator;

    /**
     * 微商城退款方式
     *
     * @see RefundModeEnum#getIndex()
     */
    @ApiModelProperty(value = "微商城退款方式", notes = RefundModeEnum.API_DOC)
    private Byte refundMode;
}
