package cn.freemud.entities.dto.store;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * Created with IntelliJ IDEA 2017.1 <br>
 * User: dll [loverochy8@gmail.com] <br>
 * Date: 2019/1/23 17:11 <br>
 * To change this template use File | Settings | File Templates. <br>
 * Description:
 */
@Data
public class StoreDelivery {
    @ApiModelProperty("主键")
    private String id;
    @ApiModelProperty("商户编号")
    private String partnerId;
    @ApiModelProperty("门店id")
    private String storeId;
    @ApiModelProperty("配送区域名称")
    private String areaName;
    @ApiModelProperty("下单范围类型 1手工画范围 2半径服务")
    private Integer positionScopeType;
    @ApiModelProperty("经纬度范围，格式：jsonArray 或者半径（米）")
    private String positionScope;
    @ApiModelProperty("起送价格（元）")
    private String minOrderPrice;
    @ApiModelProperty("商圈级别 1一级 2二级 3三级")
    private Integer businessLevel;
    @ApiModelProperty("配送方式:1-三方物流配送、2-商家自配送")
    private Integer deliveryMethod;
    @ApiModelProperty("配送费（元）")
    private String deliveryFee;
    @ApiModelProperty("配送时间（分钟）")
    private Integer deliveryTime;
    @ApiModelProperty("创建用户id")
    private String createUserId;
    @ApiModelProperty("创建时间")
    private Date createTime;
    @ApiModelProperty("更新用户id")
    private String updateUserId;
    @ApiModelProperty("更新时间")
    private Date updateTime;
    @ApiModelProperty("GC标签")
    private Integer GCFlag;

    @ApiModelProperty("基础配送范围（分）")
    private String deliveryRange;

    @ApiModelProperty("每增加多少公里（分）")
    private String addRange;

    @ApiModelProperty("每增加距离增加多少钱（分）")
    private String addRangeAmount;

    @ApiModelProperty(value="外卖起送条件（1:杯数，2:金额）")
    private Integer deliveryType;

    @ApiModelProperty( "起送杯数")
    private Integer freeDeliveryCup;

    public StoreDelivery clone() {
        StoreDelivery clone = new StoreDelivery();
        clone.setId(this.id);
        clone.setAreaName(this.areaName);
        clone.setBusinessLevel(this.businessLevel);
        clone.setCreateTime(this.createTime);
        clone.setCreateUserId(this.createUserId);
        clone.setDeliveryFee(this.deliveryFee);
        clone.setDeliveryTime(this.deliveryTime);
        clone.setGCFlag(this.GCFlag);
        clone.setMinOrderPrice(this.minOrderPrice);
        clone.setPartnerId(this.partnerId);
        clone.setPositionScope(this.positionScope);
        clone.setPositionScopeType(this.positionScopeType);
        clone.setStoreId(this.storeId);
        clone.setUpdateTime(this.updateTime);
        clone.setUpdateUserId(this.updateUserId);
        return clone;
    }
}
