package cn.freemud.entities.dto.store;

import lombok.Data;

import java.util.List;

@Data
public class StoreBusyTimeInfo {

    /**
     * 渠道
     */
    private String channel;

    /**
     * 周期类型（0每日，1工作日，2双休日，默认每日）
     */
    private Integer periodType;

    /**
     * 时间段
     */
    private List<TimeInfo> timeInfoList;

    /**
     * 文案
     */
    private String detail;

    @Data
    public static class TimeInfo {

        /**
         * 开始时间,格式HH:mm:ss,00:00:00-23:59:59
         */
        private String startTime;

        /**
         * 结束时间,格式HH:mm:ss,00:00:00-23:59:59
         */
        private String endTime;
    }
}
