package cn.freemud.entities.dto.promotion;

import io.swagger.models.auth.In;
import lombok.Data;

import java.util.List;

/**
 * @author freemud
 * @title: QuerySpellGroupVo
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/21下午5:19
 */
@Data
public class QuerySpellGroupVo {

    private String activeId;

    private String activeName;

    private String startTime;

    private String endTime;

    private Integer peopleLimit;

    /**
     * 活动总状态
     */
    private Integer activityGroupStatus;

    /**
     * 当前用户是否已参与：0-否，1-是
     */
    private Integer isJoin;
    /**
     * 当前用户订单
     */
    private String orderId;

    private Group group;

    private Good good;

    private List<Participants> participants;

    /**
     * 团信息
     */
    @Data
    public static class Group {
            /**
             * 团号
             */
            private String groupId;
            /**
             * 活动号
             */
            private String activeId;
            /**
             * 团状态：0-组团中，1-已成团，2-成团失败
             */
            private Integer groupStatus;
            /**
             * 开团开始时间
             */
            private String startTime;
            /**
             * 开团结束时间
             */
            private String endTime;
            /**
             * 差多少人成团
             */
            private Integer lessPeople;
            /**
             * 已参团人数
             */
            private Integer count;
            /**
             * 成团时间
             */
            private String groupTime;
            /**
             * 剩余时间戳毫秒
             */
            private Long time;
    }

    /**
     * 商品信息
     */
    @Data
    public static class Good {
        /**
         * 商品id
         */
        private String goodId;
        /**
         * 商品名称
         */
        private String goodName;
        /**
         * 拼团价，单位分
         */
        private Integer price;
        /**
         * 商品原价，单位分
         */
        private Integer originPrice;
    }

    @Data
    public static class Participants {
        /**
         * 是否团长：0不是，1-是
         */
        private Integer sponsor;
        /**
         * 团号
         */
        private String groupId;
        /**
         * 用户昵称
         */
        private String userName;
        /**
         * 头像
         */
        private String headUrl;
        /**
         * 订单号
         */
        private String orderId;
    }

}
