package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author freemud
 * @title: QueryHistorygroupVO
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/28下午2:45
 */
@Data
public class QueryHistoryGroupVO { //活动号
    private String activeId;
    //活动名称
    private String activeName;
    //开始时间
    private String startTime;
    //活动结束时间
    private String endTime;
    //团状态：0-组团中，1-已成团，2-成团失败
    private Integer groupStatus;
    //开团结束时间
    private String groupEndTime;
    //几人成团
    private Integer peopleLimit;
    //当前用户是否已参与：0-否，1-是
    private Integer isJoin;
    //订单号
    private String orderId;
    //参团信息集合
    private List<Participants> participants;
    //商品
    private Good good;
    //团信息
    private Group group;

    //1-活动正常  2-库存不足 3-您参与次数达到上限  6- 活动已过期
    private Integer activityGroupStatus;

    @Data
    public static class Participants {
        //是否团长：0不是，1-是
        private Integer sponsor;
        //团号
        private String groupId;
        //用户昵称
        private String userName;
        //头像
        private String headUrl;
        //参团人数
        private String orderId;
    }

    @Data
    public static class Good {
        //商品id
        private String goodId;
        //商品名称
        private String goodName;
        //拼团价，单位分
        private Integer price;
        //商品原价，单位分
        private Integer originPrice;
    }

    @Data
    public static class Group {
        //团号
        private String groupId;
        //活动号
        private String activeId;
        //团状态：0-组团中，1-已成团，2-成团失败
        private Integer groupStatus;
        //开团开始时间
        private String startTime;
        //开团结束时间
        private String endTime;
        //差多少人成团
        private Integer lessPeople;
        //已参团人数
        private Integer count;
        //成团时间
        private String groupTime;
        //剩余时间戳毫秒
        private Long time;
        //退款原因1-活动失效，10-拼团超时，11-团长退款
        private Integer reason;
    }
}
