package cn.freemud.entities.dto.promotion;

import com.freemud.sdk.api.assortment.order.entities.promption.SubtractStockVO;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class CalculationDiscountResultDto {
    //支付总金额
    private Integer totalAmount = 0;
    private Integer originalTotalAmount = 0;
    //总优惠金额
    private Integer totalDiscountAmount = 0;
    //商品优惠信息
    private List<CalculationDiscountGoodsDto> goods;
    /**
     * 可用优惠券列表
     */
    private List<UserCouponVO> userCoupons;

    /**
     * 赠券活动号列表
     */
    private List<BizCalculateSendCouponVO> sendCoupons;

    /**
     * 优惠券计算时使用了的优惠券及优惠金额
     */
    private List<CouponCalculationResultDto> couponDiscounts = new ArrayList<>();

    /**
     * 参与到的优惠活动列表
     */
    private List<CalculationGoodsActivityDto> discounts;

    /**
     * 赠送或加价换购商品列表
     */
    private List<CalculationSendGoodsVO> sendGoods;

    /**
     * 多计算结果
     */
    private List<CalculationDiscountResultDto> calculationResults;

    /**
     * 库存
     */
    private List<SubtractStockVO> stocks;

    /**
     * 商品分摊信息
     */
    private List<CalculationApportionGoodsDto> apportionGoods;
    /**
     * 活动提示语
     */
    private List<CalculationActivityPromptDto> activityPrompts;

    private Integer distributionFee;

}