package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;

public class ActivityCycleVO {
    @ApiModelProperty(value="循环类型，1：每月 2：每周 3:指定日期", name="creator", example="1")
    @Min(1)
    private Short cycleType;
    @ApiModelProperty(value="循环值，0：每月最后一天，星期一到星期天（1~7）", name="creator", example="0,1,2")
    private String cycleValue;

    @ApiModelProperty(value="周期开始时间yyyy-MM-dd 周期类型为3时必填", name="creator", example="2020-02-20")
    private String startDate;

    @ApiModelProperty(value="周期结束时间yyyy-MM-dd 周期类型为3时必填", name="creator", example="2020-02-20")
    private String endDate;

    public Short getCycleType() {
        return cycleType;
    }

    public void setCycleType(Short cycleType) {
        this.cycleType = cycleType;
    }

    public String getCycleValue() {
        return cycleValue;
    }

    public void setCycleValue(String cycleValue) {
        this.cycleValue = cycleValue;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}