package cn.freemud.entities.dto.pay;

import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.sdk.api.assortment.order.request.order.PaymentRequest;
import lombok.Data;

@Data
public class UnifiedOrderCom {

    private OrderInfoReqs orderInfo;
    private String openId;
    private Integer cashPrice;
    private Long clientCode;
    private String payTimeOutTime;


    private OrderBeanV1 orderBean;
    private PaymentRequest paymentRequest;
    private Long amount;
    private Integer cardAmount;
    private String transId;
    private String partnerPayOvertime;


    public UnifiedOrderCom() {
    }

    public UnifiedOrderCom(OrderBeanV1 orderBean, PaymentRequest paymentRequest, Long amount, Integer cardAmount, String transId, String partnerPayOvertime) {
        this.orderBean = orderBean;
        this.paymentRequest = paymentRequest;
        this.amount = amount;
        this.cardAmount = cardAmount;
        this.transId = transId;
        this.partnerPayOvertime = partnerPayOvertime;
    }
}
