package cn.freemud.entities.dto.pay;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;

@Data
public class InvoiceProductDetailRequest {

    @ApiModelProperty(value = "税收分类编码")
    @NotEmpty(message = "税收分类编码不能为空")
    private String productCode;

    @ApiModelProperty(value = "商品名称")
    @NotEmpty(message = "商品名称不能为空")
    private String productName;

    @ApiModelProperty(value = "规格型号")
    private String productSpecification;

    @ApiModelProperty(value = "计量单位")
    private String goodsUnit;

    @ApiModelProperty(value = "商品数量")
    private Integer goodsQuantity;

    @ApiModelProperty(value = "商品单价")
    private BigDecimal goodsPrice;

    @ApiModelProperty(value = "商品总价，保留两位小数")
    @NotEmpty(message = "商品总价不能为空")
    private BigDecimal goodsTotalPrice;

    @ApiModelProperty(value = "税额，保留两位小数")
    private BigDecimal goodsTotalTax;

    @ApiModelProperty(value = "税率")
    @NotEmpty(message = "税率不能为空")
    private BigDecimal goodsTaxRate;

}
