/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ItemJson
 * @Package com.freemud.o2o.dto
 * @Description:
 * @author: canlong.wu
 * @date: 2018/6/20 15:29
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
package cn.freemud.entities.dto.delivery;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Data
@ApiModel(value = "ProductInfo",description = "商品信息")
public class ProductInfo {

    /**
     *  商品编号
     */
    @ApiModelProperty(value = "商品编号")
    @NotBlank(message = "productCode不能为空")
    private String productCode;

    // ----
    @ApiModelProperty(value = "归属餐品 ID（一般套餐或者特殊要求时，该 ID 指向主餐品 ID） 0或者-1代表一级餐品数据； 一份餐品数据存在多级")
    private Long parentCode;
    
    @ApiModelProperty(value = "税率代码：10-餐品费用，13-非餐品费用；仅 taxFlag=1 改字段生效，具体税率代码参考麦 中定义")
    private Integer taxId;

    @ApiModelProperty(value = "税率：餐品费用-6，非餐品费用-13；仅 taxFlag=1 改字段生效，具体税率值参考麦中 定义")
    private Integer taxRate;
    
    @ApiModelProperty(value = "优惠金额 单位:分")
    private Long discountAmount;
    // ---
    /**
     *  商品名称
     */
    @ApiModelProperty(value = "商品名称")
    @NotBlank(message = "productName不能为空")
    private String productName;

    /**
     * 商品数量
     */
    @ApiModelProperty(value = "商品数量")
    @NotNull(message = "productNumber不能为空")
    @Min(value = 1,message = "productNumber不能小于1")
    private Integer productNumber;
    
    

    /**
     * 商品价格（分）
     */
    @ApiModelProperty(value = "商品价格（分）")
    @NotNull(message = "productPrice不能为空")
    //@Min(value = 1,message = "productPrice不能小于1")
    private Integer productPrice;

    /**
     * 商品尺寸
     */
    @ApiModelProperty(value = "商品尺寸")
    private Integer productSize;

    @ApiModelProperty(value = "商品图片 微信物流必传")
    private String productImg;

    /**
     * 商品备注
     */
    @ApiModelProperty(value = "商品备注")
    private String productRemark;
    
    @ApiModelProperty(value = "小计(单位分)")
    private Integer cumulatedTotal;
    
    @ApiModelProperty(value = "分组名称，如果订单采用分组形式，该参数为比传")
    private String GroupName;
    
}
