package cn.freemud.entities.dto.blacklist.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/5/27 14:34
 * @description :
 */
@Data
public class BlackListQueryByClient {

    /**
     * 0储值卡黑名单
     */
    public static final int RECORD_TYPE_SVC = 0;

    /**
     * 1消费黑名单
     */
    public static final int RECORD_TYPE_CUSTOMER = 1;


    @ApiModelProperty(value = "商户id")
    @NotBlank(message = "商户id不能为空")
    private String partnerId;

    @ApiModelProperty("会员id")
    private String memberId;

    @ApiModelProperty("添加的黑名单类型 0储值卡黑名单 1消费黑名单")
    @Range(min = 0, max = 1, message = "添加的黑名单类型 0储值卡黑名单 1消费黑名单")
    private Integer recordType;
}
