package cn.freemud.entities.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponCodeVerificationProductDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: biao.zhang
 * @date: 2018/11/19 17:20
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponCodeVerificationProductDto {

    /**
     * 核销数量
     */
    private Integer consume_num ;

    /**
     * 商品编号
     */
    private String pID;

    /**
     * BigDecimal, 暂未使用
     */
    private BigDecimal redeem_price;

    /**
     * 商品序号或者行数
     */
    private Integer seq ;

    /**
     * 商品名称
     */
    private String productName ;

    /**
     * 线下原价，单位：分
     */
    private Integer initPrice ;

    /**
     * 优惠后价格，单位：分
     */
    private Integer nowPrice ;

    /**
     * 应收金额，单位：分
     */
    private Integer payMoney ;
}
