package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @description:
 * @author: chengfeixiang<feixiang.cheng @ freemud.cn>
 * @date: 2022/1/25 11:26
 * @version: v1.0
 * @copyright: 2022 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
@Table(name = "open_platform_order_config")
public class OpenPlatformOrderConfig {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 自定义小程序appid
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 微信小程序appid
     */
    @Column(name = "min_app_id")
    private String minAppId;

    /**
     * 订单配置类型
     */
    @Column(name = "type")
    private String type;




    /**
     * 配置内容
     */
    @Column(name = "type_value")
    private String typeValue;


    /**
     * 配置状态 0-禁用 1-启用
     */
    @Column(name = "state")
    private Integer state;

    /**
     *
     * 配置备注
     */

    @Column(name = "remark")
    private String remark;


    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;


    /**
     * 创建时间
     */
    @Column(name = "gmt_creator")
    private String gmtCreator;

    /**
     * 修改时间
     */
    @Column(name = "gmt_updator")
    private String gmtUpdator;

}
