package cn.freemud.demoTest.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demoTest.entities.ResponseBuilder;
import cn.freemud.demoTest.entities.bo.BasePaySuccessBo;
import cn.freemud.demoTest.entities.dto.OrderInfoDemoDto;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import com.alibaba.druid.util.StringUtils;

public abstract class AbstractPaySuccessService implements PaySuccessService{



    public final String paysuccess(BasePaySuccessBo paySuccessBo, OrderInfoDemoDto orderInfoDemoDto) {
        // 基本参数校验
        this.checkParams(paySuccessBo);

        // 支付成功执行逻辑
        this.paySuccessDefault(paySuccessBo);

        // 拼装返回体
        this.paySuccessAfter(paySuccessBo);

        return "";
    }




    public final BaseResponse paySuccessDefault(BasePaySuccessBo baseRequestDTO) {
        return null;
    }


    /**
     * 请求基本参数校验
     * @return
     */
    public final BaseResponse checkParams(BasePaySuccessBo baseRequestDTO) {
        BaseResponse commonBaseResponse = this.checkCommParams(baseRequestDTO);



        return ResponseBuilder.success();
    }




    public final BaseResponse checkCommParams(BasePaySuccessBo baseRequestDTO) {

        if (StringUtils.isEmpty(baseRequestDTO.getTransId())){
            throw new ServiceException(ResponseResult.PARAMETER_MISSING);
        }

        return ResponseBuilder.success();
    }

    /**
     * 具体业务逻辑校验
     *
     * @return
     */
    public final BaseResponse paySuccessAfter(BasePaySuccessBo baseRequestDTO) {

        return ResponseBuilder.success();
    }

}
