package cn.freemud.demoTest.entities;

import cn.freemud.base.entity.BaseResponse;

public class ResponseBuilder {

    private final static String DEFAULT_VER = "1";
    private final static String SUCCESS_CODE = "100";
    private final static String SUCCESS_MESSAGE = "SUCCESS";

    /**
     * 无业务响应参数成功返回
     * @return
     */
    public static BaseResponse success() {
        return new BaseResponse(DEFAULT_VER, SUCCESS_CODE, SUCCESS_MESSAGE);
    }

    /**
     * 带有业务响应参数成功返回
     * @return
     */
    public static <T> BaseResponse success(T t) {
        return new BaseResponse(SUCCESS_CODE, SUCCESS_MESSAGE, DEFAULT_VER, t);
    }

}
